{ *********************************************************************** }
{                                                                         }
{ Delphi Visual Component Library                                         }
{                                                                         }
{ Copyright (c) 1999-2004 Borland Software Corporation                    }
{                                                                         }
{ *********************************************************************** }

unit Borland.Vcl.DBXpress platform;

{$Z+}

interface

uses Windows, System.Runtime.InteropServices, System.Text;

const

  MAXNAMELEN       = 64;
  NAMEBUFLEN       = 32;
  SQL_ERROR        = -1;
  SQL_NULL_DATA    = 100;

  DBXERR_NONE                    = $0000;
  DBXERR_WARNING                 = $0001;
  DBXERR_NOMEMORY                = $0002;
  DBXERR_INVALIDFLDTYPE          = $0003;
  DBXERR_INVALIDHNDL             = $0004;
  DBXERR_NOTSUPPORTED            = $0005;
  DBXERR_INVALIDTIME             = $0006;
  DBXERR_INVALIDXLATION          = $0007;
  DBXERR_OUTOFRANGE              = $0008;
  DBXERR_INVALIDPARAM            = $0009;
  DBXERR_EOF                     = $000A;
  DBXERR_SQLPARAMNOTSET          = $000B;
  DBXERR_INVALIDUSRPASS          = $000C;
  DBXERR_INVALIDPRECISION        = $000D;
  DBXERR_INVALIDLEN              = $000E;
  DBXERR_INVALIDTXNISOLEVEL      = $000F;
  DBXERR_INVALIDTXNID            = $0010;
  DBXERR_DUPLICATETXNID          = $0011;
  DBXERR_DRIVERRESTRICTED        = $0012;
  DBXERR_LOCALTRANSACTIVE        = $0013;
  DBXERR_MULTIPLETRANSNOTENABLED = $0014;
  DBXERR_CONNECTIONFAILED        = $0015;
  DBXERR_DRIVERINITFAILED        = $0016;
  DBXERR_OPTLOCKFAILED           = $0017;
  DBXERR_INVALIDREF              = $0018;
  DBXERR_NOTABLE                 = $0019;

  DBXERR_NODATA                  = $0064;
  DBX_MAXSTATICERRORS            = $0064;

  DBXERR_SQLERROR                = $0065;


// traceFlags

    trUNKNOWN   = $0000;
    trQPREPARE  = $0001;             { prepared query statements }
    trQEXECUTE  = $0002;             { executed query statements }
    trERROR     = $0004;             { vendor errors }
    trSTMT      = $0008;             { statement ops (i.e. allocate, free) }
    trCONNECT   = $0010;             { connect / disconnect }
    trTRANSACT  = $0020;             { transaction }
    trBLOB      = $0040;             { blob i/o }
    trMISC      = $0080;             { misc. }
    trVENDOR    = $0100;             { vendor calls }
    trDATAIN    = $0200;             { parameter bound data }
    trDATAOUT   = $0400;             { trace fetched data }

// eSQLTableType
    eSQLTable       = $0001;
    eSQLView        = $0002;
    eSQLSystemTable = $0004;
    eSQLSynonym     = $0008;
    eSQLTempTable   = $0010;
    eSQLLocal       = $0020;

// eSQLProcType
    eSQLProcedure   = $0001;
    eSQLFunction    = $0002;
    eSQLPackage     = $0004;
    eSQLSysProcedure = $0008;

// eSQLColType
    eSQLRowId       = $0001;
    eSQLRowVersion  = $0002;
    eSQLAutoIncr    = $0004;
    eSQLDefault     = $0008;

// eSQLIndexType
    eSQLNonUnique   = $0001;
    eSQLUnique      = $0002;
    eSQLPrimaryKey  = $0004;

{ Field Types (Logical) }

  fldUNKNOWN         = 0;
  fldZSTRING         = 1;               { Null terminated string }
  fldDATE            = 2;               { Date     (32 bit) }
  fldBLOB            = 3;               { Blob }
  fldBOOL            = 4;               { Boolean  (16 bit) }
  fldINT16           = 5;               { 16 bit signed number }
  fldINT32           = 6;               { 32 bit signed number }
  fldFLOAT           = 7;               { 64 bit floating point }
  fldBCD             = 8;               { BCD }
  fldBYTES           = 9;               { Fixed number of bytes }
  fldTIME            = 10;              { Time        (32 bit) }
  fldTIMESTAMP       = 11;              { Time-stamp  (64 bit) }
  fldUINT16          = 12;              { Unsigned 16 bit Integer }
  fldUINT32          = 13;              { Unsigned 32 bit Integer }
  fldFLOATIEEE       = 14;              { 80-bit IEEE float }
  fldVARBYTES        = 15;              { Length prefixed var bytes }
  fldLOCKINFO        = 16;              { Look for LOCKINFO typedef }
  fldCURSOR          = 17;              { For Oracle Cursor type }
  fldINT64           = 18;              { 64 bit signed number }
  fldUINT64          = 19;              { Unsigned 64 bit Integer }
  fldADT             = 20;              { Abstract datatype (structure) }
  fldARRAY           = 21;              { Array field type }
  fldREF             = 22;              { Reference to ADT }
  fldTABLE           = 23;              { Nested table (reference) }
  fldDATETIME        = 24;              { DateTime structure field }
  fldFMTBCD          = 25;              { BCD Variant type: required by Midas, same as BCD for DBExpress}

  MAXLOGFLDTYPES     = 26;              { Number of logical fieldtypes }

{ Sub Types (Logical) }

{ fldFLOAT subtype }

  fldstMONEY         = 21;              { Money }

{ fldBLOB subtypes }

  fldstMEMO          = 22;              { Text Memo }
  fldstBINARY        = 23;              { Binary data }
  fldstFMTMEMO       = 24;              { Formatted Text }
  fldstOLEOBJ        = 25;              { OLE object (Paradox) }
  fldstGRAPHIC       = 26;              { Graphics object }
  fldstDBSOLEOBJ     = 27;              { dBASE OLE object }
  fldstTYPEDBINARY   = 28;              { Typed Binary data }
  fldstACCOLEOBJ     = 30;              { Access OLE object }
  fldstHMEMO         = 33;              { CLOB }
  fldstHBINARY       = 34;              { BLOB }
  fldstBFILE         = 36;              { BFILE }

{ fldZSTRING subtype }

  fldstPASSWORD      = 1;               { Password }
  fldstFIXED         = 31;              { CHAR type }
  fldstUNICODE       = 32;              { Unicode }

{ fldINT32 subtype }

  fldstAUTOINC       = 29;

{ fldADT subtype }

  fldstADTNestedTable = 35;             { ADT for nested table (has no name) }

{ fldDATE subtype }
  fldstADTDATE       = 37;              { DATE (OCIDate) with in an ADT }

type

  DBINAME            =  string; // packed array [0..31] of Char; { holds a name }

  FLDVchk = (                          { Field Val Check type }
    fldvNOCHECKS,                       { Does not have explicit val checks }
    fldvHASCHECKS,                      { One or more val checks on the field }
    fldvUNKNOWN                         { Dont know at this time }
 );

  FLDRights = (                        { Field Rights }
    fldrREADWRITE,                      { Field can be Read/Written }
    fldrREADONLY,                       { Field is Read only }
    fldrNONE,                           { No Rights on this field }
    fldrUNKNOWN                         { Dont know at this time }
 );

  [StructLayout(LayoutKind.Sequential, CharSet=CharSet.Ansi, Pack=1)]
  FLDDesc = packed record               { Field Descriptor }
    iFldNum         : Word;             { Field number (1..n) }
    [MarshalAs(UnmanagedType.ByValTStr, SizeConst = NAMEBUFLEN)]
    szName          : string;           { Field name }
    iFldType        : Word;             { Field type }
    iSubType        : Word;             { Field subtype (if applicable) }
    iUnits1         : SmallInt;         { Number of Chars, digits etc }
    iUnits2         : SmallInt;         { Decimal places etc. }
    iOffset         : Word;             { Offset in the record (computed) }
    iLen            : LongWord;             { Length in bytes (computed) }
    iNullOffset     : Word;             { For Null bits (computed) }
    efldvVchk       : FLDVchk;          { Field Has vcheck (computed) }
    efldrRights     : FLDRights;        { Field Rights (computed) }
    bCalcField      : WordBool;         { Is Calculated field (computed) }
    [MarshalAs(UnmanagedType.ByValArray, SizeConst=2)]
    iUnUsed         : packed array [0..1] of Word;
  end;

  [StructLayout(LayoutKind.Sequential, CharSet=CharSet.Ansi, Pack=1)]
  ObjAttrDesc = packed record
    iFldNum    : Word;                  { Field id }
    [MarshalAs(UnmanagedType.LPSTR)]
    pszAttributeName: string; // PChar;           { Object attribute name }
  end;

  [StructLayout(LayoutKind.Sequential, CharSet=CharSet.Ansi, Pack=1)]
  ObjTypeDesc = packed record
    iFldNum    : Word;                  { Field id }
    [MarshalAs(UnmanagedType.ByValTStr, SizeConst = NAMEBUFLEN)]
    szTypeName : string;               { Object type name }
  end;

  ObjParentDesc = packed record
    iFldNum    : Word;                  { Field id }
    iParentFldNum : Word;               { Parent Field id }
  end;

  SQLResult      = Word;

type

  CBType = (                            { Call back type }
    cbGENERAL,                          { General purpose }
    cbRESERVED1,
    cbRESERVED2,
    cbINPUTREQ,                         { Input requested }
    cbRESERVED4,
    cbRESERVED5,
    cbBATCHRESULT,                      { Batch processing rslts }
    cbRESERVED7,
    cbRESTRUCTURE,                      { Restructure }
    cbRESERVED9,
    cbRESERVED10,
    cbRESERVED11,
    cbRESERVED12,
    cbRESERVED13,
    cbRESERVED14,
    cbRESERVED15,
    cbRESERVED16,
    cbRESERVED17,
    cbTABLECHANGED,                     { Table changed notification }
    cbRESERVED19,
    cbCANCELQRY,                        { Allow user to cancel Query }
    cbSERVERCALL,                       { Server Call }
    cbRESERVED22,
    cbGENPROGRESS,                      { Generic Progress report. }
    cbDBASELOGIN,                       { dBASE Login }
    cbDELAYEDUPD,                       { Delayed Updates }
    cbFIELDRECALC,                      { Field(s) recalculation }
    cbTRACE,                            { Trace }
    cbDBLOGIN,                          { Database login }
    cbDETACHNOTIFY,                     { DLL Detach Notification }
    cbNBROFCBS                          { Number of cbs }
  );

TSQLDriverOption = (eDrvBlobSize, eDrvCallBack, eDrvCallBackInfo, eDrvRestrict);

TSQLConnectionOption = (
      eConnAutoCommit, eConnBlockingMode, eConnBlobSize, eConnRoleName,
      eConnWaitOnLocks, eConnCommitRetain, eConnTxnIsoLevel,
      eConnNativeHandle, eConnServerVersion, eConnCallBack, eConnHostName,
      eConnDatabaseName, eConnCallBackInfo, eConnObjectMode,
      eConnMaxActiveComm, eConnServerCharSet, eConnSqlDialect,
      eConnRollbackRetain, eConnObjectQuoteChar, eConnConnectionName,
      eConnOSAuthentication, eConnSupportsTransaction, eConnMultipleTransaction,
      eConnServerPort,eConnOnLine, eConnTrimChar, eConnQualifiedName,
      eConnCatalogName, eConnSchemaName, eConnObjectName, eConnQuotedObjectName,
      eConnCustomInfo, eConnTimeOut, eConnConnectionString);

TSQLCommandOption = (
      eCommRowsetSize, eCommBlobSize, eCommBlockRead, eCommBlockWrite,
      eCommParamCount, eCommNativeHandle, eCommCursorName, eCommStoredProc,
      eCommSQLDialect, eCommTransactionID, eCommPackageName, eCommTrimChar, 
      eCommQualifiedName, eCommCatalogName, eCommSchemaName, eCommObjectName,
      eCommQuotedObjectName);

TSQLCursorOption = (eCurObjectAttrName, eCurObjectTypeName, eCurParentFieldID);

CBRType = (cbrUSEDEF, cbrCONTINUE, cbrABORT, cbrCHKINPUT,
      cbrYES, cbrNO, cbrPARTIALASSIST, cbrSKIP, cbrRETRY);

TSQLMetaDataOption = (eMetaCatalogName, eMetaSchemaName, eMetaDatabaseName,
                  eMetaDatabaseVersion, eMetaTransactionIsoLevel, eMetaSupportsTransaction,
                  eMetaMaxObjectNameLength, eMetaMaxColumnsInTable, eMetaMaxColumnsInSelect,
                  eMetaMaxRowSize, eMetaMaxSQLLength, eMetaObjectQuoteChar,
                  eMetaSQLEscapeChar, eMetaProcSupportsCursor, eMetaProcSupportsCursors,
                  eMetaSupportsTransactions, eMetaPackageName);

TSQLObjectType = (eObjTypeDatabase, eObjTypeDataType, eObjTypeTable,
                  eObjTypeView, eObjTypeSynonym, eObjTypeProcedure, eObjTypeUser,
                  eObjTypeRole, eObjTypeUDT, eObjTypePackage);

TTransIsolationLevel = (xilREADCOMMITTED, xilREPEATABLEREAD, xilDIRTYREAD, xilCUSTOM);

  TTransactionDesc = packed record
    TransactionID    : LongWord;             { Transaction id }
    GlobalID         : LongWord;             { Global transaction id }
    IsolationLevel   : TTransIsolationLevel; {Transaction Isolation level}
    CustomIsolation  : LongWord;             { DB specific custom isolation }
  end;

TSTMTParamType = (paramUNKNOWN, paramIN, paramOUT, paramINOUT, paramRET);

   { Function Result }
   TypedEnum      = Integer;
   SQLDATE        = Longint;
   SQLTIME        = Longint;

  TRACECat = TypedEnum;

type

{ interfaces to DBXpress objects map to IntPtr }

   ISQLDriver = IntPtr;
   ISQLConnection = IntPtr;
   ISQLCommand = IntPtr;
   ISQLCursor = IntPtr;
   ISQLMetaData = IntPtr;

{ Trace callback }

  TSQLCallbackEvent = function(
     CallType: TRACECat;
     CBInfo: IntPtr): CBRType;

function GetSQLDriver(DriverLib: HModule; DriverFunc, VendorLib, SResourceFile: string; var pDriver: IntPtr): SQLResult;

function ISQLDriver_getSQLConnection(Handle: ISQLDriver; var pConn: ISQLConnection): SQLResult;
function ISQLDriver_SetOption(Handle: ISQLDriver; eDOption: TSQLDriverOption; PropValue: LongInt): SQLResult;
function ISQLDriver_GetOption(Handle: ISQLDriver; eDOption: TSQLDriverOption;
  PropValue: IntPtr; MaxLength: SmallInt; var Length: SmallInt): SQLResult;
function ISQLDriver_release(Handle: ISQLDriver): SQLResult;

function ISQLConnection_connect(Handle: ISQLConnection; ServerName, UserName, Password: string): SQLResult;
function ISQLConnection_disconnect(Handle: ISQLConnection): SQLResult;
function ISQLConnection_release(Handle: ISQLConnection): SQLResult;
function ISQLConnection_getSQLCommand(Handle: ISQLConnection; out pComm: ISQLCommand): SQLResult;
function ISQLConnection_getSQLMetaData(Handle: ISQLConnection; out pMetaData: ISQLMetaData): SQLResult;
function ISQLConnection_SetOption(Handle: ISQLConnection; eConnectOption: TSQLConnectionOption; lValue: LongInt): SQLResult; overload;
function ISQLConnection_SetOption(Handle: ISQLConnection; eConnectOption: TSQLConnectionOption; lValue: TSQLCallbackEvent): SQLResult; overload;
function ISQLConnection_SetOption(Handle: ISQLConnection; eConnectOption: TSQLConnectionOption; lValue: string): SQLResult; overload;
function ISQLConnection_GetOption(Handle: ISQLConnection; eDOption: TSQLConnectionOption;
 PropValue: IntPtr; MaxLength: SmallInt; out Length: SmallInt): SQLResult; overload;
function ISQLConnection_GetOption(Handle: ISQLConnection; eDOption: TSQLConnectionOption;
 var PropValue: LongWord; MaxLength: SmallInt; out Length: SmallInt): SQLResult; overload;
function ISQLConnection_beginTransaction(Handle: ISQLConnection; TranID: IntPtr): SQLResult;
function ISQLConnection_commit(Handle: ISQLConnection; TranID: IntPtr): SQLResult;
function ISQLConnection_rollback(Handle: ISQLConnection; TranID: IntPtr): SQLResult;
function ISQLConnection_getErrorMessage(Handle: ISQLConnection; Error: StringBuilder): SQLResult;
function ISQLConnection_getErrorMessageLen(Handle: ISQLConnection; out ErrorLen: SmallInt): SQLResult;

function ISQLCommand_SetOption(Handle: ISQLCommand; eSqlCommandOption: TSQLCommandOption; ulValue: Integer): SQLResult; overload;
function ISQLCommand_SetOption(Handle: ISQLCommand; eSqlCommandOption: TSQLCommandOption; ulValue: string): SQLResult; overload;
function ISQLCommand_GetOption(Handle: ISQLCommand; eSqlCommandOption: TSQLCommandOption;
  PropValue: IntPtr; MaxLength: SmallInt; out Length: SmallInt): SQLResult;
function ISQLCommand_setParameter(Handle: ISQLCommand; ulParameter: Word;
 ulChildPos: Word; eParamType: TSTMTParamType; uLogType: Word; uSubType: Word;
 iPrecision: Integer; iScale: Integer; Length: LongWord; pBuffer: IntPtr;
 lInd: Integer): SQLResult;
function ISQLCommand_getParameter(Handle: ISQLCommand; ParameterNumber: Word;
  ulChildPos: Word; Value: IntPtr; Length: Integer; var IsBlank: Integer): SQLResult;
function ISQLCommand_prepare(Handle: ISQLCommand; SQL: string; ParamCount: Word): SQLResult;
function ISQLCommand_execute(Handle: ISQLCommand; var Cursor: ISQLCursor): SQLResult;
function ISQLCommand_executeImmediate(Handle: ISQLCommand; SQL: string; var Cursor: ISQLCursor): SQLResult;
function ISQLCommand_getNextCursor(Handle: ISQLCommand; var Cursor: ISQLCursor): SQLResult;
function ISQLCommand_getRowsAffected(Handle: ISQLCommand; var Rows: LongWord): SQLResult;
function ISQLCommand_close(Handle: ISQLCommand): SQLResult;
function ISQLCommand_release(Handle: ISQLCommand): SQLResult;
function ISQLCommand_getErrorMessage(Handle: ISQLCommand; Error: StringBuilder): SQLResult;
function ISQLCommand_getErrorMessageLen(Handle: ISQLCommand; out ErrorLen: SmallInt): SQLResult;

function ISQLCursor_SetOption(Handle: ISQLCursor; eOption: TSQLCursorOption; PropValue: LongInt): SQLResult;
function ISQLCursor_GetOption(Handle: ISQLCursor; eOption: TSQLCursorOption;
  PropValue: IntPtr; MaxLength: SmallInt; out Length: SmallInt): SQLResult;
function ISQLCursor_getErrorMessage(Handle: ISQLCursor; Error: StringBuilder): SQLResult;
function ISQLCursor_getErrorMessageLen(Handle: ISQLCursor; out ErrorLen: SmallInt): SQLResult;
function ISQLCursor_getColumnCount(Handle: ISQLCursor; var pColumns: Word): SQLResult;
function ISQLCursor_getColumnNameLength(Handle: ISQLCursor; ColumnNumber: Word; var pLen: Word): SQLResult;
function ISQLCursor_getColumnName(Handle: ISQLCursor; ColumnNumber: Word; pColumnName: StringBuilder): SQLResult;
function ISQLCursor_getColumnType(Handle: ISQLCursor; ColumnNumber: Word; var puType: Word; var puSubType: Word): SQLResult;
function ISQLCursor_getColumnLength(Handle: ISQLCursor; ColumnNumber: Word; var pLength: LongWord): SQLResult;
function ISQLCursor_getColumnPrecision(Handle: ISQLCursor; ColumnNumber: Word; var piPrecision: SmallInt): SQLResult;
function ISQLCursor_getColumnScale(Handle: ISQLCursor; ColumnNumber: Word; var piScale: SmallInt): SQLResult;
function ISQLCursor_isNullable(Handle: ISQLCursor; ColumnNumber: Word; var Nullable: LongBool): SQLResult;
function ISQLCursor_isAutoIncrement(Handle: ISQLCursor; ColumnNumber: Word; var AutoIncr: LongBool): SQLResult;
function ISQLCursor_isReadOnly(Handle: ISQLCursor; ColumnNumber: Word; var ReadOnly: LongBool): SQLResult;
function ISQLCursor_isSearchable(Handle: ISQLCursor; ColumnNumber: Word; var Searchable: LongBool): SQLResult;
function ISQLCursor_isBlobSizeExact(Handle: ISQLCursor; ColumnNumber: Word; var IsExact: LongBool): SQLResult;
function ISQLCursor_next(Handle: ISQLCursor): SQLResult;
function ISQLCursor_release(Handle: ISQLCursor): SQLResult;
function ISQLCursor_getString(Handle: ISQLCursor; ColumnNumber: Word; Value: IntPtr; var IsBlank: LongBool): SQLResult;
function ISQLCursor_getShort(Handle: ISQLCursor; ColumnNumber: Word; Value: IntPtr; var IsBlank: LongBool): SQLResult;
function ISQLCursor_getLong(Handle: ISQLCursor; ColumnNumber: Word; Value: IntPtr; var IsBlank: LongBool): SQLResult;
function ISQLCursor_getDouble(Handle: ISQLCursor; ColumnNumber: Word; Value: IntPtr; var IsBlank: LongBool): SQLResult;
function ISQLCursor_getBcd(Handle: ISQLCursor; ColumnNumber: Word; Value: IntPtr; var IsBlank: LongBool): SQLResult;
function ISQLCursor_getTimeStamp(Handle: ISQLCursor; ColumnNumber: Word; Value: IntPtr; var IsBlank: LongBool): SQLResult;
function ISQLCursor_getTime(Handle: ISQLCursor; ColumnNumber: Word; Value: IntPtr; var IsBlank: LongBool): SQLResult;
function ISQLCursor_getDate(Handle: ISQLCursor; ColumnNumber: Word; Value: IntPtr; var IsBlank: LongBool): SQLResult;
function ISQLCursor_getBytes(Handle: ISQLCursor; ColumnNumber: Word; Value: IntPtr; var IsBlank: LongBool): SQLResult;
function ISQLCursor_getBlobSize(Handle: ISQLCursor; ColumnNumber: Word; var Length: LongWord; var IsBlank: LongBool): SQLResult;
function ISQLCursor_getBlob(Handle: ISQLCursor; ColumnNumber: Word; Value: IntPtr;
  var IsBlank: LongBool; Length: LongWord): SQLResult;

function ISQLMetaData_SetOption(Handle: ISQLMetaData; eDOption: TSQLMetaDataOption; PropValue: LongInt): SQLResult; overload;
function ISQLMetaData_SetOption(Handle: ISQLMetaData; eDOption: TSQLMetaDataOption; PropValue: string): SQLResult; overload;
function ISQLMetaData_GetOption(Handle: ISQLMetaData; eDOption: TSQLMetaDataOption;
  PropValue: IntPtr; MaxLength: SmallInt; out Length: SmallInt): SQLResult; overload;
function ISQLMetaData_GetOption(Handle: ISQLMetaData; eDOption: TSQLMetaDataOption;
  var PropValue: Char; MaxLength: SmallInt; out Length: SmallInt): SQLResult; overload;
function ISQLMetaData_GetOption(Handle: ISQLMetaData; eDOption: TSQLMetaDataOption;
  var PropValue: LongBool; MaxLength: SmallInt; out Length: SmallInt): SQLResult; overload;
function ISQLMetaData_getObjectList(Handle: ISQLMetaData; eObjType: TSQLObjectType; out Cursor: ISQLCursor): SQLResult;
function ISQLMetaData_getTables(Handle: ISQLMetaData; TableName: string;
  TableType: LongWord; out Cursor: ISQLCursor): SQLResult; overload;
function ISQLMetaData_getTables(Handle: ISQLMetaData; TableName: IntPtr;
  TableType: LongWord; out Cursor: ISQLCursor): SQLResult; overload;
function ISQLMetaData_getProcedures(Handle: ISQLMetaData; ProcedureName: string;
  ProcType: LongWord; out Cursor: ISQLCursor): SQLResult; overload;
function ISQLMetaData_getProcedures(Handle: ISQLMetaData; ProcedureName: IntPtr;
  ProcType: LongWord; out Cursor: ISQLCursor): SQLResult; overload;
function ISQLMetaData_getColumns(Handle: ISQLMetaData; TableName: string;
  ColumnName: string; ColType: LongWord; out Cursor: ISQLCursor): SQLResult; overload;
function ISQLMetaData_getColumns(Handle: ISQLMetaData; TableName: string;
  ColumnName: IntPtr; ColType: LongWord; out Cursor: ISQLCursor): SQLResult; overload;
function ISQLMetaData_getProcedureParams(Handle: ISQLMetaData; ProcName: string;
  ParamName: string; out Cursor: ISQLCursor): SQLResult; overload;
function ISQLMetaData_getProcedureParams(Handle: ISQLMetaData; ProcName: string;
  ParamName: IntPtr; out Cursor: ISQLCursor): SQLResult; overload;
function ISQLMetaData_getIndices(Handle: ISQLMetaData; TableName: string;
  IndexType: LongWord; out Cursor: ISQLCursor): SQLResult;
function ISQLMetaData_getErrorMessage(Handle: ISQLMetaData; Error: StringBuilder): SQLResult;
function ISQLMetaData_getErrorMessageLen(Handle: ISQLMetaData; out ErrorLen: SmallInt): SQLResult;
function ISQLMetaData_release(Handle: ISQLMetaData): SQLResult;

implementation

[DllImport('DbxIntf.dll', CharSet = CharSet.Ansi, EntryPoint = 'GetSQLDriver')]
function GetSQLDriver; external;
[DllImport('DbxIntf.dll', CharSet = CharSet.Ansi, EntryPoint = 'ISQLDriver_getSQLConnection')]
function ISQLDriver_getSQLConnection; external;
[DllImport('DbxIntf.dll', CharSet = CharSet.Ansi, EntryPoint = 'ISQLDriver_SetOption')]
function ISQLDriver_SetOption; external;
[DllImport('DbxIntf.dll', CharSet = CharSet.Ansi, EntryPoint = 'ISQLDriver_GetOption')]
function ISQLDriver_GetOption; external;
[DllImport('DbxIntf.dll', CharSet = CharSet.Ansi, EntryPoint = 'ISQLDriver_release')]
function ISQLDriver_release; external;
[DllImport('DbxIntf.dll', CharSet = CharSet.Ansi, EntryPoint = 'ISQLConnection_connect')]
function ISQLConnection_connect; external;
[DllImport('DbxIntf.dll', CharSet = CharSet.Ansi, EntryPoint = 'ISQLConnection_disconnect')]
function ISQLConnection_disconnect; external;
[DllImport('DbxIntf.dll', CharSet = CharSet.Ansi, EntryPoint = 'ISQLConnection_release')]
function ISQLConnection_release; external;
[DllImport('DbxIntf.dll', CharSet = CharSet.Ansi, EntryPoint = 'ISQLConnection_getSQLCommand')]
function ISQLConnection_getSQLCommand; external;
[DllImport('DbxIntf.dll', CharSet = CharSet.Ansi, EntryPoint = 'ISQLConnection_getSQLMetaData')]
function ISQLConnection_getSQLMetaData; external;
[DllImport('DbxIntf.dll', CharSet = CharSet.Ansi, EntryPoint = 'ISQLConnection_SetOption')]
function ISQLConnection_SetOption(Handle: ISQLConnection; eConnectOption: TSQLConnectionOption; lValue: LongInt): SQLResult; external;
[DllImport('DbxIntf.dll', CharSet = CharSet.Ansi, EntryPoint = 'ISQLConnection_SetOption')]
function ISQLConnection_SetOption(Handle: ISQLConnection; eConnectOption: TSQLConnectionOption; lValue: TSQLCallbackEvent): SQLResult; external;
[DllImport('DbxIntf.dll', CharSet = CharSet.Ansi, EntryPoint = 'ISQLConnection_SetOption')]
function ISQLConnection_SetOption(Handle: ISQLConnection; eConnectOption: TSQLConnectionOption; lValue: string): SQLResult; external;
[DllImport('DbxIntf.dll', CharSet = CharSet.Ansi, EntryPoint = 'ISQLConnection_GetOption')]
function ISQLConnection_GetOption(Handle: ISQLConnection; eDOption: TSQLConnectionOption;
 PropValue: IntPtr; MaxLength: SmallInt; out Length: SmallInt): SQLResult; external;
[DllImport('DbxIntf.dll', CharSet = CharSet.Ansi, EntryPoint = 'ISQLConnection_GetOption')]
function ISQLConnection_GetOption(Handle: ISQLConnection; eDOption: TSQLConnectionOption;
 var PropValue: LongWord; MaxLength: SmallInt; out Length: SmallInt): SQLResult; external;
[DllImport('DbxIntf.dll', CharSet = CharSet.Ansi, EntryPoint = 'ISQLConnection_beginTransaction')]
function ISQLConnection_beginTransaction; external;
[DllImport('DbxIntf.dll', CharSet = CharSet.Ansi, EntryPoint = 'ISQLConnection_commit')]
function ISQLConnection_commit; external;
[DllImport('DbxIntf.dll', CharSet = CharSet.Ansi, EntryPoint = 'ISQLConnection_rollback')]
function ISQLConnection_rollback; external;
[DllImport('DbxIntf.dll', CharSet = CharSet.Ansi, EntryPoint = 'ISQLConnection_getErrorMessage')]
function ISQLConnection_getErrorMessage; external;
[DllImport('DbxIntf.dll', CharSet = CharSet.Ansi, EntryPoint = 'ISQLConnection_getErrorMessageLen')]
function ISQLConnection_getErrorMessageLen; external;
[DllImport('DbxIntf.dll', CharSet = CharSet.Ansi, EntryPoint = 'ISQLCommand_SetOption')]
function ISQLCommand_SetOption(Handle: ISQLCommand; eSqlCommandOption: TSQLCommandOption; ulValue: Integer): SQLResult; external;
[DllImport('DbxIntf.dll', CharSet = CharSet.Ansi, EntryPoint = 'ISQLCommand_SetOption')]
function ISQLCommand_SetOption(Handle: ISQLCommand; eSqlCommandOption: TSQLCommandOption; ulValue: string): SQLResult; external;
[DllImport('DbxIntf.dll', CharSet = CharSet.Ansi, EntryPoint = 'ISQLCommand_GetOption')]
function ISQLCommand_GetOption; external;
[DllImport('DbxIntf.dll', CharSet = CharSet.Ansi, EntryPoint = 'ISQLCommand_setParameter')]
function ISQLCommand_setParameter; external;
[DllImport('DbxIntf.dll', CharSet = CharSet.Ansi, EntryPoint = 'ISQLCommand_getParameter')]
function ISQLCommand_getParameter; external;
[DllImport('DbxIntf.dll', CharSet = CharSet.Ansi, EntryPoint = 'ISQLCommand_prepare')]
function ISQLCommand_prepare; external;
[DllImport('DbxIntf.dll', CharSet = CharSet.Ansi, EntryPoint = 'ISQLCommand_execute')]
function ISQLCommand_execute; external;
[DllImport('DbxIntf.dll', CharSet = CharSet.Ansi, EntryPoint = 'ISQLCommand_executeImmediate')]
function ISQLCommand_executeImmediate; external;
[DllImport('DbxIntf.dll', CharSet = CharSet.Ansi, EntryPoint = 'ISQLCommand_getNextCursor')]
function ISQLCommand_getNextCursor; external;
[DllImport('DbxIntf.dll', CharSet = CharSet.Ansi, EntryPoint = 'ISQLCommand_getRowsAffected')]
function ISQLCommand_getRowsAffected; external;
[DllImport('DbxIntf.dll', CharSet = CharSet.Ansi, EntryPoint = 'ISQLCommand_close')]
function ISQLCommand_close; external;
[DllImport('DbxIntf.dll', CharSet = CharSet.Ansi, EntryPoint = 'ISQLCommand_release')]
function ISQLCommand_release; external;
[DllImport('DbxIntf.dll', CharSet = CharSet.Ansi, EntryPoint = 'ISQLCommand_getErrorMessage')]
function ISQLCommand_getErrorMessage; external;
[DllImport('DbxIntf.dll', CharSet = CharSet.Ansi, EntryPoint = 'ISQLCommand_getErrorMessageLen')]
function ISQLCommand_getErrorMessageLen; external;
[DllImport('DbxIntf.dll', CharSet = CharSet.Ansi, EntryPoint = 'ISQLCursor_SetOption')]
function ISQLCursor_SetOption; external;
[DllImport('DbxIntf.dll', CharSet = CharSet.Ansi, EntryPoint = 'ISQLCursor_GetOption')]
function ISQLCursor_GetOption; external;
[DllImport('DbxIntf.dll', CharSet = CharSet.Ansi, EntryPoint = 'ISQLCursor_getErrorMessage')]
function ISQLCursor_getErrorMessage; external;
[DllImport('DbxIntf.dll', CharSet = CharSet.Ansi, EntryPoint = 'ISQLCursor_getErrorMessageLen')]
function ISQLCursor_getErrorMessageLen; external;
[DllImport('DbxIntf.dll', CharSet = CharSet.Ansi, EntryPoint = 'ISQLCursor_getColumnCount')]
function ISQLCursor_getColumnCount; external;
[DllImport('DbxIntf.dll', CharSet = CharSet.Ansi, EntryPoint = 'ISQLCursor_getColumnNameLength')]
function ISQLCursor_getColumnNameLength; external;
[DllImport('DbxIntf.dll', CharSet = CharSet.Ansi, EntryPoint = 'ISQLCursor_getColumnName')]
function ISQLCursor_getColumnName; external;
[DllImport('DbxIntf.dll', CharSet = CharSet.Ansi, EntryPoint = 'ISQLCursor_getColumnType')]
function ISQLCursor_getColumnType; external;
[DllImport('DbxIntf.dll', CharSet = CharSet.Ansi, EntryPoint = 'ISQLCursor_getColumnLength')]
function ISQLCursor_getColumnLength; external;
[DllImport('DbxIntf.dll', CharSet = CharSet.Ansi, EntryPoint = 'ISQLCursor_getColumnPrecision')]
function ISQLCursor_getColumnPrecision; external;
[DllImport('DbxIntf.dll', CharSet = CharSet.Ansi, EntryPoint = 'ISQLCursor_getColumnScale')]
function ISQLCursor_getColumnScale; external;
[DllImport('DbxIntf.dll', CharSet = CharSet.Ansi, EntryPoint = 'ISQLCursor_isNullable')]
function ISQLCursor_isNullable; external;
[DllImport('DbxIntf.dll', CharSet = CharSet.Ansi, EntryPoint = 'ISQLCursor_isAutoIncrement')]
function ISQLCursor_isAutoIncrement; external;
[DllImport('DbxIntf.dll', CharSet = CharSet.Ansi, EntryPoint = 'ISQLCursor_isReadOnly')]
function ISQLCursor_isReadOnly; external;
[DllImport('DbxIntf.dll', CharSet = CharSet.Ansi, EntryPoint = 'ISQLCursor_isSearchable')]
function ISQLCursor_isSearchable; external;
[DllImport('DbxIntf.dll', CharSet = CharSet.Ansi, EntryPoint = 'ISQLCursor_isBlobSizeExact')]
function ISQLCursor_isBlobSizeExact; external;
[DllImport('DbxIntf.dll', CharSet = CharSet.Ansi, EntryPoint = 'ISQLCursor_next')]
function ISQLCursor_next; external;
[DllImport('DbxIntf.dll', CharSet = CharSet.Ansi, EntryPoint = 'ISQLCursor_release')]
function ISQLCursor_release; external;
[DllImport('DbxIntf.dll', CharSet = CharSet.Ansi, EntryPoint = 'ISQLCursor_getString')]
function ISQLCursor_getString; external;
[DllImport('DbxIntf.dll', CharSet = CharSet.Ansi, EntryPoint = 'ISQLCursor_getShort')]
function ISQLCursor_getShort; external;
[DllImport('DbxIntf.dll', CharSet = CharSet.Ansi, EntryPoint = 'ISQLCursor_getLong')]
function ISQLCursor_getLong; external;
[DllImport('DbxIntf.dll', CharSet = CharSet.Ansi, EntryPoint = 'ISQLCursor_getDouble')]
function ISQLCursor_getDouble; external;
[DllImport('DbxIntf.dll', CharSet = CharSet.Ansi, EntryPoint = 'ISQLCursor_getBcd')]
function ISQLCursor_getBcd; external;
[DllImport('DbxIntf.dll', CharSet = CharSet.Ansi, EntryPoint = 'ISQLCursor_getTimeStamp')]
function ISQLCursor_getTimeStamp; external;
[DllImport('DbxIntf.dll', CharSet = CharSet.Ansi, EntryPoint = 'ISQLCursor_getTime')]
function ISQLCursor_getTime; external;
[DllImport('DbxIntf.dll', CharSet = CharSet.Ansi, EntryPoint = 'ISQLCursor_getDate')]
function ISQLCursor_getDate; external;
[DllImport('DbxIntf.dll', CharSet = CharSet.Ansi, EntryPoint = 'ISQLCursor_getBytes')]
function ISQLCursor_getBytes; external;
[DllImport('DbxIntf.dll', CharSet = CharSet.Ansi, EntryPoint = 'ISQLCursor_getBlobSize')]
function ISQLCursor_getBlobSize; external;
[DllImport('DbxIntf.dll', CharSet = CharSet.Ansi, EntryPoint = 'ISQLCursor_getBlob')]
function ISQLCursor_getBlob; external;
[DllImport('DbxIntf.dll', CharSet = CharSet.Ansi, EntryPoint = 'ISQLMetaData_SetOption')]
function ISQLMetaData_SetOption(Handle: ISQLMetaData; eDOption: TSQLMetaDataOption; PropValue: LongInt): SQLResult; external;
[DllImport('DbxIntf.dll', CharSet = CharSet.Ansi, EntryPoint = 'ISQLMetaData_SetOption')]
function ISQLMetaData_SetOption(Handle: ISQLMetaData; eDOption: TSQLMetaDataOption; PropValue: string): SQLResult; external;
[DllImport('DbxIntf.dll', CharSet = CharSet.Ansi, EntryPoint = 'ISQLMetaData_GetOption')]
function ISQLMetaData_GetOption(Handle: ISQLMetaData; eDOption: TSQLMetaDataOption;
  PropValue: IntPtr; MaxLength: SmallInt; out Length: SmallInt): SQLResult; external;
[DllImport('DbxIntf.dll', CharSet = CharSet.Ansi, EntryPoint = 'ISQLMetaData_GetOption')]
function ISQLMetaData_GetOption(Handle: ISQLMetaData; eDOption: TSQLMetaDataOption;
  var PropValue: Char; MaxLength: SmallInt; out Length: SmallInt): SQLResult; external;
[DllImport('DbxIntf.dll', CharSet = CharSet.Ansi, EntryPoint = 'ISQLMetaData_GetOption')]
function ISQLMetaData_GetOption(Handle: ISQLMetaData; eDOption: TSQLMetaDataOption;
  var PropValue: LongBool; MaxLength: SmallInt; out Length: SmallInt): SQLResult; external;
[DllImport('DbxIntf.dll', CharSet = CharSet.Ansi, EntryPoint = 'ISQLMetaData_getObjectList')]
function ISQLMetaData_getObjectList; external;
[DllImport('DbxIntf.dll', CharSet = CharSet.Ansi, EntryPoint = 'ISQLMetaData_getTables')]
function ISQLMetaData_getTables(Handle: ISQLMetaData; TableName: string;
  TableType: LongWord; out Cursor: ISQLCursor): SQLResult; external;
[DllImport('DbxIntf.dll', CharSet = CharSet.Ansi, EntryPoint = 'ISQLMetaData_getTables')]
function ISQLMetaData_getTables(Handle: ISQLMetaData; TableName: IntPtr;
  TableType: LongWord; out Cursor: ISQLCursor): SQLResult; external;
[DllImport('DbxIntf.dll', CharSet = CharSet.Ansi, EntryPoint = 'ISQLMetaData_getProcedures')]
function ISQLMetaData_getProcedures(Handle: ISQLMetaData; ProcedureName: string;
  ProcType: LongWord; out Cursor: ISQLCursor): SQLResult; external;
[DllImport('DbxIntf.dll', CharSet = CharSet.Ansi, EntryPoint = 'ISQLMetaData_getProcedures')]
function ISQLMetaData_getProcedures(Handle: ISQLMetaData; ProcedureName: IntPtr;
  ProcType: LongWord; out Cursor: ISQLCursor): SQLResult; external;
[DllImport('DbxIntf.dll', CharSet = CharSet.Ansi, EntryPoint = 'ISQLMetaData_getColumns')]
function ISQLMetaData_getColumns(Handle: ISQLMetaData; TableName: string;
  ColumnName: string; ColType: LongWord; out Cursor: ISQLCursor): SQLResult; external;
[DllImport('DbxIntf.dll', CharSet = CharSet.Ansi, EntryPoint = 'ISQLMetaData_getColumns')]
function ISQLMetaData_getColumns(Handle: ISQLMetaData; TableName: string;
  ColumnName: IntPtr; ColType: LongWord; out Cursor: ISQLCursor): SQLResult; external;
[DllImport('DbxIntf.dll', CharSet = CharSet.Ansi, EntryPoint = 'ISQLMetaData_getProcedureParams')]
function ISQLMetaData_getProcedureParams(Handle: ISQLMetaData; ProcName: string;
  ParamName: string; out Cursor: ISQLCursor): SQLResult; external;
[DllImport('DbxIntf.dll', CharSet = CharSet.Ansi, EntryPoint = 'ISQLMetaData_getProcedureParams')]
function ISQLMetaData_getProcedureParams(Handle: ISQLMetaData; ProcName: string;
  ParamName: IntPtr; out Cursor: ISQLCursor): SQLResult; external;
[DllImport('DbxIntf.dll', CharSet = CharSet.Ansi, EntryPoint = 'ISQLMetaData_getIndices')]
function ISQLMetaData_getIndices; external;
[DllImport('DbxIntf.dll', CharSet = CharSet.Ansi, EntryPoint = 'ISQLMetaData_getErrorMessage')]
function ISQLMetaData_getErrorMessage; external;
[DllImport('DbxIntf.dll', CharSet = CharSet.Ansi, EntryPoint = 'ISQLMetaData_getErrorMessageLen')]
function ISQLMetaData_getErrorMessageLen; external;
[DllImport('DbxIntf.dll', CharSet = CharSet.Ansi, EntryPoint = 'ISQLMetaData_release')]
function ISQLMetaData_release; external;

end.

